
CREATE TABLE yazdCategory (
  categoryID     integer NOT NULL,
  name           VARCHAR2(255),
  description    varchar2(2000),
  modifiedDate   VARCHAR2(15),
  creationDate   VARCHAR2(15),
  catorder	 integer
);
ALTER TABLE yazdCategory
  ADD ( 
    PRIMARY KEY (categoryID) 
  );



CREATE TABLE yazdFilter (
  filterObject   BLOB,
  forumID        integer NOT NULL,
  filterIndex    integer NOT NULL
);
CREATE INDEX filterIndexIdx ON YazdFilter (
  filterIndex  ASC
);
ALTER TABLE YazdFilter
  ADD ( 
    PRIMARY KEY (forumID,filterIndex) 
  );

CREATE TABLE yazdForum (
  forumID           integer NOT NULL,
  name              VARCHAR2(255),
  description       varchar2(2000),
  modifiedDate      VARCHAR2(15),
  creationDate      VARCHAR2(15),
  moderated         integer NOT NULL,
  forumGroupID      integer NOT NULL,
  article	    integer not null,
  forumorder        int
);
ALTER TABLE YazdForum
  ADD ( 
    PRIMARY KEY (forumID) 
  );



CREATE TABLE yazdForumGroup (
  forumGroupID      integer NOT NULL,
  categoryID        integer NOT NULL,
  name              VARCHAR2(255),
  description       varchar2(2000),
  modifiedDate      VARCHAR2(15),
  creationDate      VARCHAR2(15),
  grporder	    integer
) ;
ALTER TABLE yazdForumGroup
  ADD ( 
    PRIMARY KEY (forumGroupID) 
  );




CREATE TABLE yazdForumProp (
  forumID     integer NOT NULL,
  name        VARCHAR2(30) NOT NULL,
  propValue   VARCHAR2(255) NOT NULL
);
ALTER TABLE YazdForumProp
  ADD (
    PRIMARY KEY (forumID,name)
  );

CREATE TABLE yazdGroup (
  groupID      integer NOT NULL,
  name         VARCHAR2(50) NOT NULL,
  description  VARCHAR2(255),
  automember   integer not null
);
ALTER TABLE YazdGroup
  ADD ( 
    PRIMARY KEY (groupID) 
  );


CREATE TABLE yazdGroupPerm (
  forumID      integer NOT NULL,
  groupID      integer NOT NULL,
  permission   integer NOT NULL
);
CREATE INDEX groupGroupIdx ON YazdGroupPerm (
  groupID   ASC
);

ALTER TABLE YazdGroupPerm
  ADD ( 
    PRIMARY KEY (forumID, groupID, permission) 
  );

CREATE TABLE yazdGroupUser (
  groupID        integer NOT NULL,
  userID         integer NOT NULL,
  administrator  integer NOT NULL
);

CREATE INDEX groupIdx ON YazdGroupUser (
  userID     ASC
);
ALTER TABLE YazdGroupUser
  ADD ( 
    PRIMARY KEY (groupID, userID)
  );


CREATE TABLE yazdMessage (
  messageID     integer NOT NULL,
  threadID      integer NOT NULL DEFAULT -1,
  subject       VARCHAR2(255),
  userID        integer NOT NULL,
  body          long varchar null,
  modifiedDate  VARCHAR2(15) NOT NULL,
  creationDate  VARCHAR2(15) NOT NULL,
  approved      integer NOT NULL,
  ranking       integer null,
  replyPrivateUserId integer NOT NULL DEFAULT 0
);
CREATE INDEX messageApprovedIdx ON YazdMessage (
  approved    ASC
);
CREATE INDEX messageThreadIDIdx ON YazdMessage (
  threadID    ASC
);
CREATE INDEX messageCreationDateIdx ON YazdMessage (
  creationDate    ASC
);
CREATE INDEX messageModifiedDateIdx ON YazdMessage (
  modifiedDate    ASC
);
CREATE INDEX messageUserIDIdx ON YazdMessage (
  userID    ASC
);
ALTER TABLE YazdMessage
  ADD ( 
    PRIMARY KEY (messageID)
  );


CREATE TABLE yazdMessageTree (
  parentID   integer NOT NULL,
  childID    integer NOT NULL
);
CREATE INDEX childIdx ON YazdMessageTree (
  childID      ASC
);
ALTER TABLE YazdMessageTree
  ADD ( 
    PRIMARY KEY (parentID, childID) 
  );

CREATE TABLE yazdMessageProp (
  messageID    integer NOT NULL,
  name         VARCHAR2(30) NOT NULL,
  propValue    VARCHAR2(255) NOT NULL
);
ALTER TABLE YazdMessageProp
  ADD ( 
    PRIMARY KEY (messageID, name) 
  );


create table yazdThreadType(
  typeID   integer not null,
  name     VARCHAR2(25) not null
);
ALTER TABLE yazdThreadType
  ADD ( 
    PRIMARY KEY (typeID) 
  );

insert into yazdThreadType values(0,'Other');
insert into yazdThreadType values(1,'Question');
insert into yazdThreadType values(2,'Comment');
insert into yazdThreadType values(3,'Announcement');


CREATE TABLE yazdThread (
  threadID      integer NOT NULL,
  forumID       integer NOT NULL,
  rootMessageID integer NOT NULL,
  approved      integer NOT NULL,
  readcnt       integer NOT NULL,
  typeID        integer not null,
  sticky        integer not null,
  closedflag    integer not null,
  creationDate  VARCHAR2(15) NOT NULL,
  modifiedDate  VARCHAR2(15) NOT NULL
);
CREATE INDEX threadCreationDateIdx ON YazdThread (
  creationDate    ASC
);
CREATE INDEX threadModifiedDateIdx ON YazdThread (
  modifiedDate    ASC
);
CREATE INDEX threadForumIDIdx ON YazdThread (
  forumID    ASC
);
ALTER TABLE YazdThread
  ADD ( 
    PRIMARY KEY (threadID) 
  );   

CREATE TABLE yazdUser (
  userID        integer NOT NULL,
  name          VARCHAR2(50),
  username      VARCHAR2(30) NOT NULL,
  passwordHash  VARCHAR2(32) NOT NULL,
  email         VARCHAR2(75) NOT NULL
);
ALTER TABLE YazdUser
  ADD ( 
    PRIMARY KEY (userID) 
  );

CREATE TABLE yazdUserPerm (
  forumID      integer NOT NULL,
  userID       integer NOT NULL,
  permission   integer NOT NULL
);
CREATE INDEX userUserIdx ON YazdUserPerm (
  userID    ASC
);
ALTER TABLE YazdUserPerm
  ADD ( 
    PRIMARY KEY (forumID, userID, permission)
  );

CREATE TABLE yazdUserProp (
  userID     integer NOT NULL,
  name       VARCHAR2(30) NOT NULL,
  propValue  VARCHAR2(255) NOT NULL
);
ALTER TABLE YazdUserProp
  ADD ( 
    PRIMARY KEY (userID, name) 
  );



CREATE TABLE yazdProps (
       propvalue            VARCHAR2(255),
       name                 VARCHAR2(80) NOT NULL
);
ALTER TABLE yazdProps
       ADD PRIMARY KEY (name);

CREATE UNIQUE INDEX XPKYAZD_props ON yazdProps
(
       name
);
CREATE TABLE yazdBlackList(
  ip		  VARCHAR2(30) not null,
  clientip	  VARCHAR2(30),
  blockcount	  integer
);

CREATE TABLE yazdArticleMap(
  pageKey       VARCHAR2(255) not null,
  forumID       integer not null,
  threadID      integer not null
);
create table yazdSessions(
  sessionID   VARCHAR2(255) not null,
  IP          VARCHAR2(255) not null,
  userID      integer null,
  lasttime    integer not null,
  initime     integer not null
);
alter table yazdSessions
  add primary key (sessionID);

create table yazdUserStats(
   day_dt integer not null,
   usercount integer not null, 
   maxusercount integer not null, 
   maxuserdt VARCHAR2(15)
);

alter table yazdUserStats add primary key (day_dt);

commit; 
